# ADOBE CONFIDENTIAL
#
# Copyright 2010-2021 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#

import os, sys
sys.path.append(os.path.abspath(os.path.join(os.path.split(__file__)[0], "include")))
import base
import substance

#==============================================================================
# Notes:
#   - The function parameters names MUST NOT be changed because they are used by the application to identify each parameter
#   - Use the class 'substance.SBSDocument' to query the content of a .sbs file
#   - The parameter 'aContext' contains information about the application context (urls aliases, progressInfo...)
#==============================================================================

def onBeforeFileLoaded(aContext, aFileAbsPath):
    """
    Called when a file is about to be loaded from disk
    :param aFileAbsPath: The absolute path of the file
    :return: a substance.ReturnValue() object that contains the following keys:
        userData: User data as string
    """
    returnValue = base.ReturnValue()
    returnValue.setValue('userData', '')
    return returnValue

def onAfterFileLoaded(aContext, aFileAbsPath, aSucceed, aUpdated, aUserData):
    """
    Called when after a save process has been triggered
    :param aFileAbsPath: The absolute path of the file
    :param aSucceed: The result of the save process
    :param aUpdated: If the package was updated when loading
    :param aUserData: The userData value set in field "userData' of the returnValue object returned
        by the onBeforeFileSaved() function
    :return: Nothing
    """
    pass

def onBeforeFileSaved(aContext, aFileAbsPath = '', aPackageFileAbsPath=''):
    """
    Called when a file is about to be saved on disk
    :param aFileAbsPath: The absolute path of the file
    :param aPackageFileAbsPath: The path of the pacakge that contains the exported data (if any)
    :return: a substance.ReturnValue() object that contains the following keys:
        userData: User data as string
    """
    # Build return value
    returnValue = base.ReturnValue()
    returnValue.setValue('userData', '')
    return returnValue

def onAfterFileSaved(aContext, aFileAbsPath = '', aSucceed = True, aUserData = ''):
    """
    Called when after a save process has been triggered
    :param aFileAbsPath: The absolute path of the file
    :param aSucceed: The result of the save process
    :param aUserData: The userData value set in field "userData' of the returnValue object returned
        by the onBeforeFileSaved() function
    :return: Nothing
    """
    pass

def getGraphExportOptions(aContext, aPackageFileAbsPath = '', aGraphIdentifier = ''):
    """
    Get the options used to fill the widget used to export a graph outputs
    :param aPackageFileAbsPath: The absolute path of the package (i.e. the .sbs file)
    :return: a substance.ReturnValue() object that contains the following keys:
        outputDirAbsPath: absolute path of the directory used to export
        fileExtension: the image file extension (png, tga, ...)
    """

    # Build return value
    returnValue = base.ReturnValue()
    returnValue.setValue('outputDirAbsPath', '')
    returnValue.setValue('fileExtension', '')
    returnValue.setValue('pattern', '')
    return returnValue

#==============================================================================
if __name__ == "__main__":
    base.CommandLineArgsProcessor(__name__).call()
